#include <windows.h>
#include <stdio.h>

#include <gl/glew.h>
#include <gl/wglew.h>

class CShader
{
public:
	bool loadShader(char *sFile, int a_iType);
	void deleteShader();

	bool isLoaded();
	UINT getShaderID();

	CShader();

private:
	UINT uiShader;
	int iType;
	bool bLoaded;
};

class CShaderProgram
{
public:
	void createProgram();
	void deleteProgram();

	bool addShaderToProgram(CShader* shShader);
	bool linkProgram();

	void useProgram();

	UINT getProgramID();

	CShaderProgram();

private:
	UINT uiProgram;
	bool bLinked;
};
